*****************************************************************************
**                      Replication do-file for article                    **
** Continuity Trumps? The impact of interviewer change on item nonresponse **
**                  authors: Kristin Hajek & Nina Schumann                 ** 
*****************************************************************************

*************************
** 2) Respondent moves **
*************************

** Moves; generated from data set biomob_ehc

use "$w7data\biomob_ehc.dta", clear  // does NOT include moves within same city

* only main residence relevant (variable "resid")
drop if resid==2  // 945 rows deleted

* drop if place of residence only between waves, not at time of any interview
replace rescurrw6=1 if respw6==1 & resbeg<=intdatw6  & (resend>=intdatw6 | resend==97) // correction rescurrw6 (bug in data set)
replace rescurrw7=-3 if respw7!=1 // correction rescurrw7 (bug in data set)
gen inbetween=1 if rescurrw1!=1 & rescurrw2!=1 & rescurrw3!=1 & rescurrw4!=1 & rescurrw5!=1 & rescurrw6!=1 & rescurrw7!=1
*br id rescurrw* inbetween
drop if inbetween==1  // 481 rows deleted

* generate number at time of interview wave x
forvalues x=1/7 {
	gen resnumber_w`x'=resnumber if rescurrw`x'==1
	bysort id: egen resnr_w`x'=max(resnumber_w`x')
}
forvalues x=2/7 {
	tab resnr_w`x' if respw`x'==1, m // check if missings
	*l id if resnr_w`x'==. & respw`x'==1
}

* mark waves without current main residence mentioned
forvalues x=1/7 {
	replace rescurrw`x'=. if rescurrw`x'<0
	bysort id: egen totalcurrw`x'=total(rescurrw`x') 
	cap noi replace totalcurrw`x'=. if respw`x'!=1 & `x'>1
}

* generate variable "move" using identification variable "resnumber_w"
forvalues x=1/5 {
	local y=`x'+1
	local z=`x'+2
	gen movew`x'w`y'=1 if resnr_w`x'!=resnr_w`y' & intdatw`x'>0 & intdatw`y'>0 & totalcurrw`y'!=0
	gen movew`x'w`z'=1 if resnr_w`x'!=resnr_w`z' & intdatw`x'>0 & intdatw`y'<0 & intdatw`z'>0 & totalcurrw`z'!=0  // gap of 1 wave
}
gen movew1w4=1 if resnr_w1!=resnr_w4 & intdatw2==-10 & intdatw3<0 & intdatw4>0 & totalcurrw4!=0  // gap in wave 3; DemoDiff
gen movew6w7=1 if resnr_w6!=resnr_w7 & intdatw6>0 & intdatw7>0 & totalcurrw6!=0 & totalcurrw7!=0

forvalues x=2/7 {
	gen move_tow`x'=.
	forvalues y=1/6 {
		cap noi replace move_tow`x'=1 if movew`y'w`x'==1 
}
}

* check: move and no current residence?
forvalues x=2/7 {
	tab move_tow`x' if  totalcurrw`x'==0, m
	l id if move_tow`x'==1 & totalcurrw`x'==0
}

* distance
tab resdis, m 

*br if resdis==-99 // place not known --> resdis not known (even though move did take place)
*br if resdis==-98 // no calculation possible if place not known (even though move did take place)
*br if resdis==-2 // no answer if place not known (even though move did take place)

*br id resdis residplace rescurr* move*  // some places more than once --> resnumber (moved back)

forvalues x=2/7 {
	gen resdis_tow`x'=resdis if move_tow`x'==1 & resdis!=-3 & rescurrw`x'==1
}

* fill in
forvalues x=2/7 {
	bysort id: egen move_w`x'=max(move_tow`x')
	bysort id: egen resdis_w`x'=max(resdis_tow`x')
}

* ever moved between cities? 
order move_w*, last
egen move_ever_b=rownonmiss(move_w2-move_w7)   
tab move_ever_b, m

*br id rescurr* move* resdis* if resdis!=-3 & move_ever_b==0 & resdis!=-99 & resdis!=-2
*br if inlist(id,425605000,503402000)  // okay
*br if id==134112000

* keep one row for each person
sort id 
bysort id: keep if _n==_N

count  // 10827
tab move_ever_b, m  
*	br id move* resdis* if move_ever_b>1
	
* rename "move" --> "between"
forvalues x=2/7 {
	qui cap noi rename move_w`x' between_w`x'
	tab  resdis_w`x' if between_w`x'==1, m
}

* merge data set which includes moves within the same city	
merge 1:1 id using "$w7data\biomob_ehc_moves.dta"
drop _merge
drop *_sr

tab1 mig0*, m  // very few cases >0 --> not sensible to include
	drop mig0*
tab1 within*, m // these are changes within the same city between waves

forvalues x=1/7 {
	forvalues y=1/7 {
		qui cap noi rename within_w`x'_w`y'_mr within_w`x'w`y'
	}
}
forvalues x=2/7 {
	gen move_within_w`x'=.
	forvalues y=1/6 {
		cap noi replace move_within_w`x'=1 if within_w`y'w`x'==1 
}
}
foreach var of varlist move_within* {
	recode `var' -3=. 0=.
}

* ever moved within cities? 
egen move_ever_w=rownonmiss(move_within_w2-move_within_w7)   
tab move_ever_w, m

* all moves (between and within cities)
forvalues x=2/7 {
		cap noi gen move_w`x'=between_w`x'
		cap noi replace move_w`x'=1 if move_within_w`x'==1
}

* ever moved at all?
egen move_ever=rownonmiss(move_w2-move_w7)   
tab1 move_ever*, m

* keep only relevant variables
keep id move_w? between_w? move_within_* resdis_w* 


save "$Intwechsel\2_move.dta", replace 



